<?php
    $pageTitle = 'Edit Loan Product';
    $pageSubtitle = 'Update configuration for ' . $loanType->product;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($pageTitle); ?> | ZedBankOS</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        /* --- ZEDBANKOS THEME COLORS --- */
        :root {
            --zedbank-blue: #0077C5; 
            --zedbank-blue-dark: #005A94; 
        }
        .bg-primary { background-color: var(--zedbank-blue); }
        .hover\:bg-secondary:hover { background-color: var(--zedbank-blue-dark); }
        .focus\:ring-primary:focus { --tw-ring-color: var(--zedbank-blue); }
        .focus\:border-primary:focus { border-color: var(--zedbank-blue); }
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { .lg\:ml-64 { margin-left: 0 !important; } }
        .quickbooks-input-readonly { background-color: #F3F2F1; color: #605E5C; cursor: not-allowed; }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    
    <?php echo $__env->make('accounting.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="lg:ml-64 min-h-screen">
        <?php echo $__env->make('accounting.partials.header', ['title' => $pageTitle, 'subtitle' => $pageSubtitle], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="p-6">
            <div class="max-w-4xl mx-auto">
                <div class="bg-white rounded-lg shadow-sm border border-gray-200">
                    <form action="<?php echo e(route('admin.accounting.products.update', $loanType->id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        
                        <div class="p-6 space-y-8">
                            <section>
                                <h3 class="text-lg font-semibold text-gray-800 mb-4 border-b pb-2">Basic Information</h3>
                                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                    <div class="md:col-span-1">
                                        <label class="block text-sm font-medium text-gray-700 mb-2">Product Name *</label>
                                        <input type="text" name="product" required class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary" value="<?php echo e(old('product', $loanType->product)); ?>">
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700 mb-2">Interest Method *</label>
                                        <select name="interest_method" required class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary">
                                            <option value="reducing_balance" <?php echo e(old('interest_method', $loanType->interest_method) == 'reducing_balance' ? 'selected' : ''); ?>>Reducing Balance</option>
                                            <option value="simple_interest" <?php echo e(old('interest_method', $loanType->interest_method) == 'simple_interest' ? 'selected' : ''); ?>>Simple Interest</option>
                                        </select>
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700 mb-2">Status *</label>
                                        <select name="status" required class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary">
                                            <option value="Active" <?php echo e($loanType->status == 'Active' ? 'selected' : ''); ?>>Active</option>
                                            <option value="Inactive" <?php echo e($loanType->status == 'Inactive' ? 'selected' : ''); ?>>Inactive</option>
                                        </select>
                                    </div>
                                    <div class="md:col-span-3">
                                        <label class="block text-sm font-medium text-gray-700 mb-2">Description *</label>
                                        <input type="text" name="details" required class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary" value="<?php echo e(old('details', $loanType->details)); ?>">
                                    </div>
                                </div>
                            </section>

                            <section>
                                <h3 class="text-lg font-semibold text-gray-800 mb-4 border-b pb-2">Interest Rates (%)</h3>
                                <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                                    <div><label class="block text-sm font-medium text-gray-700 mb-2">Daily</label><input type="number" step="0.01" name="dailyrate" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary" value="<?php echo e(old('dailyrate', $loanType->dailyrate)); ?>"></div>
                                    <div><label class="block text-sm font-medium text-gray-700 mb-2">Weekly</label><input type="number" step="0.01" name="weeklyrate" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary" value="<?php echo e(old('weeklyrate', $loanType->weeklyrate)); ?>"></div>
                                    <div><label class="block text-sm font-bold text-blue-700 mb-2">Monthly *</label><input type="number" step="0.01" name="monthlyrate" id="monthlyrate" required class="w-full border-2 border-blue-200 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary" value="<?php echo e(old('monthlyrate', $loanType->monthlyrate)); ?>" oninput="computeYearlyRate()"></div>
                                    <div><label class="block text-sm font-medium text-gray-400 mb-2">Yearly (Auto)</label><input type="number" step="0.01" name="yearlyrate" id="yearlyrate" readonly class="w-full border border-gray-300 rounded-lg px-3 py-2 quickbooks-input-readonly" value="<?php echo e(old('yearlyrate', $loanType->yearlyrate)); ?>"></div>
                                </div>
                            </section>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                                <section>
                                    <h3 class="text-lg font-semibold text-gray-800 mb-4 border-b pb-2">Processing Fee</h3>
                                    <div class="space-y-4">
                                        <input type="number" step="0.01" name="processing_fee" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary" value="<?php echo e(old('processing_fee', $loanType->processing_fee)); ?>">
                                        <div class="flex items-center gap-4 text-sm text-gray-700">
                                            <label class="flex items-center"><input type="radio" name="processing_fee_basis" value="initial_amount" <?php echo e($loanType->processing_fee_basis == 'initial_amount' ? 'checked' : ''); ?> class="mr-2"> Initial Amt</label>
                                            <label class="flex items-center"><input type="radio" name="processing_fee_basis" value="outstanding_balance" <?php echo e($loanType->processing_fee_basis == 'outstanding_balance' ? 'checked' : ''); ?> class="mr-2"> Outstanding</label>
                                        </div>
                                    </div>
                                </section>
                                <section>
                                    <h3 class="text-lg font-semibold text-gray-800 mb-4 border-b pb-2">Late Penalty</h3>
                                    <div class="space-y-4">
                                        <input type="number" step="0.01" name="penalty_rate" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary" value="<?php echo e(old('penalty_rate', $loanType->penalty_rate)); ?>">
                                        <select name="penalty_basis" class="w-full border border-gray-300 rounded-lg px-3 py-2 focus:ring-primary focus:border-primary">
                                            <option value="fixed" <?php echo e($loanType->penalty_basis == 'fixed' ? 'selected' : ''); ?>>Fixed Amount</option>
                                            <option value="percentage_of_due" <?php echo e($loanType->penalty_basis == 'percentage_of_due' ? 'selected' : ''); ?>>% of Due Amount</option>
                                            <option value="percentage_of_outstanding" <?php echo e($loanType->penalty_basis == 'percentage_of_outstanding' ? 'selected' : ''); ?>>% of Total Outstanding</option>
                                        </select>
                                    </section>
                                </div>
                            </div>
                        </div>

                        <div class="bg-gray-50 px-6 py-4 border-t border-gray-200 rounded-b-lg flex justify-end space-x-3">
                            <a href="<?php echo e(route('admin.accounting.products.index')); ?>" class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50 transition">Cancel</a>
                            <button type="submit" class="px-6 py-2 bg-primary text-white rounded-lg hover:bg-secondary transition font-semibold shadow-sm">
                                <i class="fas fa-save mr-2"></i> Update Product
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>

    <script>
        function computeYearlyRate() {
            const monthly = parseFloat(document.getElementById('monthlyrate').value) || 0;
            document.getElementById('yearlyrate').value = (monthly * 12).toFixed(2);
        }
    </script>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/accounting/products/edit.blade.php ENDPATH**/ ?>