<?php
    $pageTitle = isset($quotation) ? 'Edit Loan Quotation' : 'Loan Quotation Builder';
    $pageSubtitle = 'Configure payment frequency and interest methods with locked base rates';
    $themeBlue = '#0077C5';
    $themeBlueDark = '#005A94';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($pageTitle); ?> | ZedBankOS</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <style>
        :root {
            --zedbank-blue: <?php echo e($themeBlue); ?>; 
            --zedbank-blue-dark: <?php echo e($themeBlueDark); ?>; 
        }
        .bg-zedbank-blue { background-color: var(--zedbank-blue); }
        .bg-primary { background-color: var(--zedbank-blue); }
        .bg-primary-dark { background-color: var(--zedbank-blue-dark); }
        .text-zedbank-blue { color: var(--zedbank-blue); }
        .lg\:ml-64 { margin-left: 16rem; }
        @media (max-width: 1024px) { .lg\:ml-64 { margin-left: 0 !important; } }

        .compact-input { padding: 10px 14px; font-size: 0.875rem; border: 1px solid #d1d5db; border-radius: 0.5rem; width: 100%; transition: all 0.2s; }
        .compact-input:focus { border-color: var(--zedbank-blue); outline: none; box-shadow: 0 0 0 3px rgba(0, 119, 197, 0.1); }
        .compact-label { font-size: 0.875rem; font-weight: 600; color: #374151; margin-bottom: 0.5rem; display: block; }
        
        .config-card { background: white; border-radius: 0.75rem; border: 1px solid #e5e7eb; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1); padding: 1.5rem; }
        .config-card-header { display: flex; align-items: center; padding-bottom: 1rem; margin-bottom: 1.5rem; border-bottom: 1px solid #f3f4f6; }
        .config-card-header h2 { font-size: 1.125rem; font-weight: 700; color: #111827; }

        .readonly-input { background-color: #f9fafb; color: #6b7280; cursor: not-allowed; border-color: #e5e7eb; font-weight: 600; }
        .effective-input { background-color: #f0f9ff; color: var(--zedbank-blue); font-weight: 700; border-color: #bae6fd; }
        
        #loading-overlay { display: none; background: rgba(255,255,255,0.9); z-index: 1000; backdrop-filter: blur(2px); position: fixed; inset: 0; }
        
        .loading-spinner {
            border: 3px solid #f3f3f3; border-top: 3px solid var(--zedbank-blue);
            border-radius: 50%; width: 40px; height: 40px;
            animation: spin 1s linear infinite;
        }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }

        #toast-container { position: fixed; top: 1.5rem; right: 1.5rem; z-index: 9999; }
        .toast {
            display: flex; align-items: center; background: white; padding: 1rem 1.5rem; border-radius: 0.75rem; 
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1); border-left: 4px solid var(--zedbank-blue); 
            margin-bottom: 0.75rem; transform: translateX(120%); transition: transform 0.3s ease-in-out;
        }
        .toast.show { transform: translateX(0); }
        .toast-success { border-left-color: #10b981; }
        .toast-error { border-left-color: #ef4444; }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    
    <div id="toast-container"></div>

    <?php echo $__env->make('accounting.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="lg:ml-64 min-h-screen flex flex-col relative">
        <div id="loading-overlay" class="flex flex-col items-center justify-center">
            <div class="loading-spinner"></div>
            <p class="font-bold text-gray-600 mt-4">Processing Quotation...</p>
        </div>

        <?php echo $__env->make('accounting.partials.header', ['title' => $pageTitle, 'subtitle' => $pageSubtitle], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="p-6">
            <div class="max-w-4xl mx-auto space-y-6 pb-20">
                
                <input type="hidden" id="quotation_id" value="<?php echo e($quotation->id ?? ''); ?>">
                <input type="hidden" id="quotation_number" value="<?php echo e($quotation->quotation_number ?? ''); ?>">
                
                
                <div class="config-card">
                    <div class="config-card-header">
                        <i class="fas fa-user-check mr-3 text-zedbank-blue text-lg"></i>
                        <h2>Client & Product Selection</h2>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="compact-label">Customer Name</label>
                            <input type="text" id="q_customer_name" class="compact-input" placeholder="e.g. John Doe" 
                                   value="<?php echo e($quotation->customer_name ?? ''); ?>">
                        </div>
                        <div>
                            <label class="compact-label">Loan Product Template</label>
                            <select id="product_id" class="compact-input" onchange="applyProductTemplate(this)">
                                <option value="">Manual Entry</option>
                                <?php $__currentLoopData = $loanProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($product->id); ?>" 
                                        <?php echo e((isset($quotation) && $quotation->product_id == $product->id) ? 'selected' : ''); ?>

                                        data-daily-rate="<?php echo e($product->dailyrate ?? 0); ?>"
                                        data-weekly-rate="<?php echo e($product->weeklyrate ?? 0); ?>"
                                        data-monthly-rate="<?php echo e($product->monthlyrate ?? 5); ?>"
                                        data-proc-rate="<?php echo e($product->processing_fee ?? 0); ?>"
                                        data-admin-rate="<?php echo e($product->adminfee ?? 0); ?>"
                                        data-insurance-rate="<?php echo e($product->insurancefee ?? 0); ?>"
                                        data-method="<?php echo e($product->interest_method ?? 'reducing_balance'); ?>">
                                        <?php echo e($product->product); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                </div>

                
                <div class="config-card">
                    <div class="config-card-header">
                        <i class="fas fa-money-bill-wave mr-3 text-green-600 text-lg"></i>
                        <h2>Loan Principal & Tenure</h2>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div>
                            <label class="compact-label">Principal Amount (ZMW)</label>
                            <input type="number" id="q_amount" class="compact-input font-bold" 
                                   value="<?php echo e($quotation->principal_amount ?? 10000); ?>" onchange="recalculateAll()">
                        </div>
                        <div>
                            <label class="compact-label" id="tenure_label">Tenure (Months)</label>
                            <input type="number" id="q_tenure" class="compact-input" 
                                   value="<?php echo e($quotation->tenure ?? 12); ?>" onchange="recalculateAll()">
                        </div>
                        <div>
                            <label class="compact-label">Frequency</label>
                            <select id="q_frequency" class="compact-input" onchange="handleFrequencyChange()">
                                <option value="monthly" <?php echo e((isset($quotation) && $quotation->tenure_type == 'monthly') ? 'selected' : ''); ?>>Monthly</option>
                                <option value="weekly" <?php echo e((isset($quotation) && $quotation->tenure_type == 'weekly') ? 'selected' : ''); ?>>Weekly</option>
                                <option value="daily" <?php echo e((isset($quotation) && $quotation->tenure_type == 'daily') ? 'selected' : ''); ?>>Daily</option>
                            </select>
                        </div>
                    </div>
                </div>

                
                <div class="config-card">
                    <div class="config-card-header">
                        <i class="fas fa-percent mr-3 text-blue-600 text-lg"></i>
                        <h2>Interest Calculation</h2>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                        <div>
                            <label class="compact-label">Interest Method</label>
                            <select id="q_interest_method" class="compact-input" onchange="recalculateAll()">
                                <option value="reducing_balance" <?php echo e((isset($quotation) && $quotation->interest_method == 'reducing_balance') ? 'selected' : ''); ?>>Reducing Balance</option>
                                <option value="simple_interest" <?php echo e((isset($quotation) && $quotation->interest_method == 'simple_interest') ? 'selected' : ''); ?>>Simple Interest</option>
                            </select>
                        </div>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div>
                            <label class="compact-label">Base Rate (%)</label>
                            <input type="number" id="q_base_interest" class="compact-input readonly-input" 
                                   value="<?php echo e($quotation->base_interest_rate ?? 0); ?>" readonly>
                        </div>
                        <div>
                            <label class="compact-label">Discount (%)</label>
                            <input type="number" id="q_discount" class="compact-input text-green-600 font-semibold" 
                                   value="<?php echo e($quotation->interest_discount ?? 0); ?>" step="0.01" onchange="recalculateAll()">
                        </div>
                        <div>
                            <label class="compact-label">Effective Rate</label>
                            <input type="number" id="q_net_interest" class="compact-input effective-input" 
                                   value="<?php echo e($quotation->effective_interest_rate ?? 0); ?>" readonly>
                        </div>
                    </div>
                </div>

                
                <div class="config-card">
                    <div class="config-card-header">
                        <i class="fas fa-cogs mr-3 text-orange-500 text-lg"></i>
                        <h2>Processing Fee</h2>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div>
                            <label class="compact-label">Base Fee (%)</label>
                            <input type="number" id="q_base_proc" class="compact-input readonly-input" 
                                   value="<?php echo e($quotation->base_processing_rate ?? 0); ?>" readonly>
                        </div>
                        <div>
                            <label class="compact-label">Discount (%)</label>
                            <input type="number" id="q_proc_discount" class="compact-input text-green-600 font-semibold" 
                                   value="<?php echo e($quotation->processing_discount ?? 0); ?>" step="0.01" onchange="recalculateAll()">
                        </div>
                        <div>
                            <label class="compact-label">Effective Fee (%)</label>
                            <input type="number" id="q_net_proc" class="compact-input effective-input" 
                                   value="<?php echo e($quotation->effective_processing_rate ?? 0); ?>" readonly>
                        </div>
                    </div>
                </div>

                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="config-card">
                        <label class="compact-label">Admin Rate (%)</label>
                        <input type="number" id="q_admin_rate" class="compact-input" 
                               value="<?php echo e($quotation->admin_rate ?? 0); ?>" step="0.01" onchange="recalculateAll()">
                    </div>
                    <div class="config-card">
                        <label class="compact-label">Insurance Rate (%)</label>
                        <input type="number" id="q_insurance_rate" class="compact-input" 
                               value="<?php echo e($quotation->insurance_rate ?? 0); ?>" step="0.01" onchange="recalculateAll()">
                    </div>
                </div>

                
                <div class="flex flex-wrap md:flex-nowrap gap-3 pt-6">
                    
                    <button type="button" onclick="saveQuotation('draft')" 
                            class="flex-1 inline-flex items-center justify-center px-6 py-3 bg-white border border-gray-300 text-gray-700 rounded-lg font-bold hover:bg-gray-50 transition shadow-sm text-sm uppercase tracking-wider">
                        <i class="fas fa-save mr-2 text-gray-400"></i> Save Draft
                    </button>

                    
                    <button type="button" onclick="saveQuotation('active')" 
                            class="flex-1 inline-flex items-center justify-center px-6 py-3 bg-zedbank-blue text-white rounded-lg font-bold hover:bg-primary-dark transition shadow-md text-sm uppercase tracking-wider">
                        <i class="fas fa-calculator mr-2"></i> Generate Schedule
                    </button>

                    
                    <button type="button" onclick="saveQuotation('complete')" 
                            class="flex-1 inline-flex items-center justify-center px-6 py-3 bg-green-600 text-white rounded-lg font-bold hover:bg-green-700 transition shadow-md text-sm uppercase tracking-wider">
                        <i class="fas fa-check-double mr-2"></i> Complete Quote
                    </button>
                </div>
            </div>
        </main>
    </div>

    <script>
        function showToast(message, type = 'success') {
            const id = 'toast-' + Date.now();
            const icon = type === 'success' ? 'fa-check-circle text-green-500' : 'fa-exclamation-circle text-red-500';
            const html = `<div id="${id}" class="toast toast-${type}"><i class="fas ${icon} mr-3 text-lg"></i><span class="font-semibold text-gray-700">${message}</span></div>`;
            $('#toast-container').append(html);
            setTimeout(() => $(`#${id}`).addClass('show'), 10);
            setTimeout(() => { $(`#${id}`).removeClass('show'); setTimeout(() => $(`#${id}`).remove(), 300); }, 4000);
        }

        function handleFrequencyChange() {
            const freq = $('#q_frequency').val();
            $('#tenure_label').text(`Tenure (${freq.charAt(0).toUpperCase() + freq.slice(1)}s)`);
            const opt = $('#product_id option:selected');
            if (opt.val()) { $('#q_base_interest').val($(opt).data(`${freq}-rate`)); }
            recalculateAll();
        }

        function applyProductTemplate(select) {
            const opt = select.options[select.selectedIndex];
            if (!opt.value) { $('#q_base_interest, #q_base_proc').val(0); recalculateAll(); return; }
            const freq = $('#q_frequency').val();
            $('#q_base_interest').val($(opt).data(`${freq}-rate`));
            $('#q_base_proc').val($(opt).data('proc-rate'));
            $('#q_admin_rate').val($(opt).data('admin-rate'));
            $('#q_insurance_rate').val($(opt).data('insurance-rate'));
            $('#q_interest_method').val($(opt).data('method'));
            $('#q_discount, #q_proc_discount').val(0);
            recalculateAll();
        }

        function recalculateAll() {
            const bInt = parseFloat($('#q_base_interest').val()) || 0;
            const dInt = parseFloat($('#q_discount').val()) || 0;
            $('#q_net_interest').val((bInt - dInt).toFixed(4));

            const bProc = parseFloat($('#q_base_proc').val()) || 0;
            const dProc = parseFloat($('#q_proc_discount').val()) || 0;
            $('#q_net_proc').val((bProc - dProc).toFixed(4));
        }

        function saveQuotation(status) {
            const clientName = $('#q_customer_name').val().trim();
            if (!clientName) { 
                showToast('Customer name is required.', 'error'); 
                return; 
            }

            $('#loading-overlay').fadeIn(200);
            recalculateAll();

            const payload = {
                _token: '<?php echo e(csrf_token()); ?>',
                id: $('#quotation_id').val(),
                quotation_number: $('#quotation_number').val(),
                status: status,
                customer_name: clientName,
                product_id: $('#product_id').val(),
                principal_amount: $('#q_amount').val(),
                tenure: $('#q_tenure').val(),
                tenure_type: $('#q_frequency').val(),
                interest_method: $('#q_interest_method').val(),
                base_interest_rate: $('#q_base_interest').val(),
                interest_discount: $('#q_discount').val(),
                interest_rate: $('#q_net_interest').val(),
                base_processing_rate: $('#q_base_proc').val(),
                processing_discount: $('#q_proc_discount').val(),
                effective_processing_rate: $('#q_net_proc').val(),
                admin_rate: $('#q_admin_rate').val(),
                insurance_rate: $('#q_insurance_rate').val(),
            };

            $.ajax({
                url: '<?php echo e(route("admin.quotations.store")); ?>',
                type: 'POST',
                data: payload,
                success: function(response) {
                    if(response.success) {
                        if (status === 'active' || status === 'complete') {
                            window.location.href = "<?php echo e(url('admin/quotations')); ?>/" + response.quotation_id + "/show";
                        } else {
                            $('#quotation_id').val(response.quotation_id);
                            showToast('Draft saved successfully.');
                            $('#loading-overlay').fadeOut(200);
                        }
                    }
                },
                error: function(xhr) {
                    showToast(xhr.responseJSON?.message || 'Error processing request.', 'error');
                    $('#loading-overlay').fadeOut(200);
                }
            });
        }

        $(document).ready(function() {
            recalculateAll();
        });
    </script>
</body>
</html><?php /**PATH /home/topacvbu/public_html/zedbankos.cloud/manageportal/resources/views/admin/quotations/create.blade.php ENDPATH**/ ?>